package game;

import java.awt.Color;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;


public class GoalSprite implements BlockInterface, MovingObject {
	
	private CustomImageDataII[] goalImages;
	private CustomImageDataII[] endCutsceneImages;
	private int endCutsceneFrame;
	
	private int goalXPos;
	private int goalYPos;
	
	private int goalFrame;
	
	public static final int GOAL_START_HEIGHT = 55;
	public static final int GOAL_WIDTH = 67;
	
	private boolean passThru;
	private boolean showCommentary;
	
	private boolean isGoingDown;
	
	public GoalSprite(int xPos, int yPos, PonyPanel ponyPanel, boolean shouldBePassThrough, boolean shouldShowCommentary) {
		
		goalImages = new CustomImageDataII[11];
		
		goalImages[0] = new CustomImageDataII("/images/goal.GIF", Color.green, ponyPanel);
		
		for(int i = 1; i < 11; i++) {
			goalImages[i] = new CustomImageDataII("/images/goal_down" + i + ".GIF", Color.green, ponyPanel);
		}
		
		
		goalXPos = xPos;
		goalYPos = yPos;
		passThru = shouldBePassThrough;
		showCommentary = shouldShowCommentary;
		
		goalFrame = 0;
		isGoingDown = false;
		endCutsceneFrame = 0;
		
		endCutsceneImages = new CustomImageDataII[0];
	}
	
	
	@Override
	public IntRect getCollisionRect() {
		IntRect returnValue = new IntRect(goalXPos - GOAL_WIDTH / 2, goalYPos - GOAL_START_HEIGHT / 2 + goalFrame, GOAL_WIDTH, GOAL_START_HEIGHT - goalFrame); 
		return returnValue;
	}
	
	@Override
	public boolean isPlayerSpriteBlocked(CollidableObject player) {

		IntRect blockRect = getCollisionRect();
		
		IntRect playerRect = player.getNextPosCollisionRect();
		
		return blockRect.intersects(playerRect);
		
	}
	
	@Override
	public void draw(Graphics g, PlayerSprite player, int panelWidth,
			int panelHeight) {

		goalImages[goalFrame].drawObject(g, panelWidth/2 + (goalXPos - player.getxPos()) , panelHeight/2 + (goalYPos - player.getyPos()));
		
	}
	
	@Override
	public void draw(Graphics g, int playerX, int playerY, int panelWidth,
			int panelHeight) {

		goalImages[goalFrame].drawObject(g, panelWidth/2 + (goalXPos - playerX) , panelHeight/2 + (goalYPos - playerY));
		
	}
	
	@Override
	public int getxPos() {
		return goalXPos;
	}
	@Override
	public void setxPos(int xPos) {
		goalXPos = xPos;
	}
	@Override
	public int getyPos() {
		return goalYPos;
	}
	@Override
	public void setyPos(int yPos) {
		goalYPos = yPos;
	}
	@Override
	public void primeImage(Graphics g) {
		
	}
	@Override
	public boolean isPassThrough() {
		return passThru;
	}
	@Override
	public int getCollisionRectMinY() {
		return goalYPos - GOAL_START_HEIGHT / 2 + goalFrame;
	}
	@Override
	public int getCollisionRectMaxY() {
		return goalYPos - GOAL_START_HEIGHT / 2 + GOAL_START_HEIGHT;
	}
	@Override
	public int getCollisionRectMinX() {
		return goalXPos - GOAL_WIDTH / 2;
	}
	@Override
	public int getCollisionRectMaxX() {
		return goalXPos - GOAL_WIDTH / 2 + GOAL_WIDTH;
	}
	@Override
	public int getWidth() {
		return GOAL_WIDTH;
	}
	@Override
	public int getHeight() {
		return GOAL_START_HEIGHT - goalFrame;
	}
	@Override
	public boolean isPlayerCurrentlyOnBlock(PlayerSprite player) {
		IntRect playerRect = player.getCurrentPosCollisionRect();
		IntRect blockRect = getCollisionRect();

		if(!doesPlayerHaveXOverlap(playerRect, blockRect))
			return false;
		
		int difference = playerRect.getMaxY() + 1 - blockRect.getMinY();
		
//		System.err.println("<><>DELME player.getMaxY is: " + playerRect.getMaxY() + ", block's minY is: " + blockRect.getMinY());
		
		return difference < 2 && difference > -2;
	}
	@Override
	public boolean isPlayerCurrentlyBonkedOnBlock(PlayerSprite player) {

		IntRect playerRect = player.getCurrentPosCollisionRect();
		IntRect blockRect = getCollisionRect();
		
		if(!doesPlayerHaveXOverlap(playerRect, blockRect))
			return false;
		
		double difference = playerRect.getMinY() + 1.0 - blockRect.getMaxY();
		
//		System.err.println("<><>DELME player.getMinY is: " + playerRect.getMinY() + ", block's maxY is: " + blockRect.getMaxX());
		
		return difference < 1.0 && difference > -1.0;
		
	}
	
	
	public boolean doesPlayerHaveXOverlap(IntRect playerRect, IntRect blockRect) {
		if(playerRect.getMaxX() < blockRect.getMinX() || playerRect.getMinX() > blockRect.getMaxX())
			return false;
		else
			return true;
	}
	
	

	public boolean doesPlayerHaveYOverlap(IntRect playerRect, IntRect blockRect) {
		if(playerRect.getMaxY() < blockRect.getMinY() || playerRect.getMinY() > blockRect.getMaxY())
			return false;
		else
			return true;
	}
	
	
	@Override
	public String getName() {
		return "GOAL!!";
	}
	
	public void update(PlayerSprite player, PonyPanel caller) {
		
		if(!isGoingDown && this.isPlayerCurrentlyOnBlock(player)) {
			isGoingDown = true;
			player.setCutsceneMode();
			player.insistOnGraphicalStand();
			if(caller.getRain() != null)
				caller.getRain().setShouldRain(false);
			return;
		}
		
		if(isGoingDown) { 
			if(goalFrame < goalImages.length - 1) {
				goalFrame++;
				player.setyPos(player.getyPos() + 1);
			} else {
				if(caller.getRain() == null || caller.getRain().isDoneRaining()) {
					//really, we need a cutscene here!
					
					if(caller.isShowingEndingCutscene()) {
						endCutsceneFrame++;
//						System.out.println("<><>DELME endCutsceneFrame: "+ endCutsceneFrame);
						if(endCutsceneFrame >= endCutsceneImages.length) {
//							System.out.println("<><>DELME game over!");
							//game over!
							endCutsceneFrame--;
//							caller.setShowingEndingCutscene(false);
							if(!showCommentary) {
								caller.goToMenuResumeNotAllowed();
							} else { 
								caller.setShowingCommentaryUnlocked();
								caller.goToMenuResumeNotAllowedCommentaryAllowed();
								
							}
						}
					} else {
//						try {Thread.sleep(15000);} catch(Throwable t) {}
						caller.setShowingEndingCutscene(true);
					}
					
					
				}
			}
		}
		
	}


	@Override
	public char getDir() {
		return 'd';
	}
	
	private GoalSprite(PonyPanel ponyPanel) {

		goalImages = new CustomImageDataII[11];
		
		goalImages[0] = new CustomImageDataII("/images/goal.GIF", Color.green, ponyPanel);
		
		for(int i = 1; i < 11; i++) {
			goalImages[i] = new CustomImageDataII("/images/goal_down" + i + ".GIF", Color.green, ponyPanel);
		}
		
		goalFrame = 0;
		isGoingDown = false;
		endCutsceneFrame =0;
	}
	
	public static GoalSprite readFromFile(BufferedReader in, PonyPanel caller, boolean fromFiles, String roomName) throws IOException {
		
		GoalSprite returnValue = new GoalSprite(caller);
		
		String inputter;
		String tempArray[];
		
		int endFrames = -1;
		int currentFrame = 0;
		
		while((inputter = in.readLine()) != null) {
			
			if(inputter.trim().equals("/goal")) {
				return returnValue;
			} else {
				
				if(endFrames == -1) {
				
					if(inputter.contains("x:")) {
						returnValue.setxPos(Integer.parseInt(inputter.substring(2).trim()));
					} else if(inputter.contains("y:")) {
						returnValue.setyPos(Integer.parseInt(inputter.substring(2).trim()));
					} else if(inputter.contains("passThru")) {
						returnValue.passThru = true;
					} else if(inputter.contains("solid")) {
						returnValue.passThru = false;
					} else if(inputter.contains("tutorial")) {
						returnValue.showCommentary = false;
					} else if(inputter.contains("commentary")) {
						returnValue.showCommentary = true;
					} else if(inputter.contains("endFrames:")) {
						returnValue.endCutsceneImages = new CustomImageDataII[Integer.parseInt(inputter.substring(10).trim())];
						endFrames = returnValue.endCutsceneImages.length;
					}
				} else {
					tempArray = inputter.split("\\*");
					if(fromFiles) {
						returnValue.endCutsceneImages[currentFrame] = CustomImageDataIIRepository.loadImage(new File(tempArray[0]), tempArray != null && tempArray.length > 1 ? CustomImageData.translateFileInStringToColor(tempArray[1].trim()) : null, caller, roomName, tempArray[0]);
								//new CustomImageDataII(new File(tempArray[0]), tempArray != null && tempArray.length > 1 ? CustomImageData.translateFileInStringToColor(tempArray[1].trim()) : null, caller);
						
					} else {
						returnValue.endCutsceneImages[currentFrame] = CustomImageDataIIRepository.loadImage(tempArray[0], tempArray != null && tempArray.length > 1 ? CustomImageData.translateFileInStringToColor(tempArray[1].trim()) : null, caller, roomName); 
								//new CustomImageDataII(tempArray[0], tempArray != null && tempArray.length > 1 ? CustomImageData.translateFileInStringToColor(tempArray[1].trim()) : null, caller);
					}
					currentFrame++;
				}
			}
			
		}
		
		
		
		
		
		return returnValue;
		
		
	}
	
	public CustomImageDataII getEndCutsceneImage() {
		if(endCutsceneImages == null || endCutsceneFrame < 0 || endCutsceneFrame >= endCutsceneImages.length) {
			return null;
		}
		return endCutsceneImages[endCutsceneFrame];
	}
	
	public void resetGoalButton() {
		goalFrame = 0;
		isGoingDown = false;
		endCutsceneFrame = 0;
	}
	
	
	
	

	public static void retrieveFileLengths(BufferedReader in, PonyPanel caller, boolean fromFiles, String roomName, HashMap<String, Long> fileLengths) throws IOException {
		
//		GoalSprite returnValue = new GoalSprite(caller);
		
		String inputter;
		String tempArray[];
		
		int endFrames = -1;
		int currentFrame = 0;
		
		while((inputter = in.readLine()) != null) {
			
			if(inputter.trim().equals("/goal")) {
				return ;
			} else {
				
				if(endFrames == -1) {
				
					if(inputter.contains("x:")) {
//						returnValue.setxPos(Integer.parseInt(inputter.substring(2).trim()));
					} else if(inputter.contains("y:")) {
//						returnValue.setyPos(Integer.parseInt(inputter.substring(2).trim()));
					} else if(inputter.contains("passThru")) {
//						returnValue.passThru = true;
					} else if(inputter.contains("solid")) {
//						returnValue.passThru = false;
					} else if(inputter.contains("tutorial")) {
//						returnValue.showCommentary = false;
					} else if(inputter.contains("commentary")) {
//						returnValue.showCommentary = true;
					} else if(inputter.contains("endFrames:")) {
//						returnValue.endCutsceneImages = new CustomImageDataII[];
						endFrames = Integer.parseInt(inputter.substring(10).trim());
					}
				} else {
					tempArray = inputter.split("\\*");
					
					FileInputStream fis = new FileInputStream(new File(tempArray[0]));
					
					long lengthOfFile = 0L;
					
					while(fis.read() != -1)
						lengthOfFile++;
					
					fis.close();
					
					fileLengths.put(tempArray[0], lengthOfFile);
					
//					if(fromFiles) {
//						returnValue.endCutsceneImages[currentFrame] = CustomImageDataIIRepository.loadImage(new File(tempArray[0]), tempArray != null && tempArray.length > 1 ? CustomImageData.translateFileInStringToColor(tempArray[1].trim()) : null, caller, roomName, tempArray[0]);
//								//new CustomImageDataII(new File(tempArray[0]), tempArray != null && tempArray.length > 1 ? CustomImageData.translateFileInStringToColor(tempArray[1].trim()) : null, caller);
//						
//					} else {
//						returnValue.endCutsceneImages[currentFrame] = CustomImageDataIIRepository.loadImage(tempArray[0], tempArray != null && tempArray.length > 1 ? CustomImageData.translateFileInStringToColor(tempArray[1].trim()) : null, caller, roomName); 
//								//new CustomImageDataII(tempArray[0], tempArray != null && tempArray.length > 1 ? CustomImageData.translateFileInStringToColor(tempArray[1].trim()) : null, caller);
//					}
//					currentFrame++;
				}
			}
			
		}
		
		
		
		
		
//		return returnValue;
		
		
	}
	
}
